# Cisco Global Threat Alerts (GTA) Overview

## Purpose and Capabilities

- GTA helps identify security breaches from malware without known signatures.
- Uses statistical and mathematical models to correlate large amounts of data.
- Detects novel and emerging threats by identifying command-and-control (CnC) activity.
- Reduces time to discovery of internal threats, addressing gaps in perimeter-based security.
- Applies machine learning, behavioral analysis, and anomaly detection.

---

## Key Features

### Detection Methods

- Investigates suspicious web traffic using network behavior analysis.
- Excels at identifying zero-day threats via long-term analysis of abnormal events.
- Detects discreet, small-scale incidents that might otherwise go unnoticed.

### Threat Coverage

- Focuses on threats using web-based CnC (over 90% of attacks).
- Identifies botnets, rootkits, malvertising, and other malware.
- Detects attacks establishing a presence in the network.

### Cloud-Based SaaS

- GTA is delivered as a cloud-based software as a service (SaaS).
- Automates investigation and alerting for suspicious web traffic and breached devices.
- Quickly detects ongoing attacks in the customer’s environment.

---

## Service Updates

- GTA service ends on July 31, 2024; all support ends after this date.
- Cisco recommends Cisco XDR (Extended Detection and Response) for future cloud-delivered analytics.
- On-premise alternatives: Converged Analytics feature and Cisco Talos Threat Intelligence feed.

---

## Benefits of Confirmed Threat Identification

- Eliminates false positives.
- Reduces time for security analysts to determine root cause.
- Enables faster threat remediation by IT teams.

---

## Integration with Secure Network Analytics

### Behavioral Analytics & Machine Learning

- GTA engine correlates enterprise and global threat behaviors.
- Learns and adapts to changing network behavior over time.
- Consumes syslog information from proxy sources using the Proxy License feature.

### Web Proxy Integration

- Enhances visibility into web traffic passing through proxies.
- Provides detailed logs (URL and domain) for behavioral analysis.
- Supports integration with Cisco Secure Web Appliance and third-party proxies (McAfee, Blue Coat, Squid).
- Proxy logs sent to Flow Collector, correlated with NetFlow data for deeper visibility.

### Data Flow

- Flow Collectors send proxy logs and NetFlow to GTA cloud for analysis.
- GTA cloud returns analyzed results to the Manager.
- Communication uses HTTPS (TCP 443) and SCP (TCP 22); can route through proxy servers.

---

## Alerting and Investigation

### Risk Ratings & Campaign Attribution

- GTA provides a risk-level rating for each detection.
- Details on malicious campaigns, techniques, and recommended remediation are provided when possible.

### Dashboard & User Experience

- GTA widget on the Manager dashboard shows machine learning-powered threat detections.
- Uses Indicators of Compromise (IPs, hostnames, domains) to identify malware.
- Alerts are tiered by risk, with the highest risk threats displayed first.
- Users can drill down into alerts for more details in the GTA GUI dashboard:
    - View first/last seen times, detected threats, affected users, and IPs.
    - Asset details show associated events, connection patterns, and behavioral results.

---

**Summary:**  
Cisco Global Threat Alerts (GTA) uses cloud-based machine learning and behavioral analytics to detect advanced, web-based, and zero-day threats in network traffic—even in cases where traditional signature-based detection fails. It integrates with Secure Network Analytics and web proxy solutions to deliver actionable, prioritized alerts and detailed threat investigations, but is scheduled for end-of-service in July 2024, with Cisco XDR recommended as the successor.